/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.impl2.AnimationManager;
import filenet.sim.animationdp.impl2.IVWSIMEventReader;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;

class VWSimLocalFileReader
implements IVWSIMEventReader {
    private String m_localFileName = null;
    private File m_localFile = null;
    private RandomAccessFile m_file = null;
    private long m_nCurrentElement = 0L;
    protected static Logger logger = Logger.getLogger("filenet.sim.animationdp");
    private String m_className = "VWSimLocalFileReader";
    private boolean m_finished = false;
    private ArrayList posList = new ArrayList(1);
    private long m_pos = 0L;
    private ArrayList timeList = new ArrayList();

    private void checkDATFile(String fileName) throws VWException {
        this.m_className = this.m_className + ";";
        this.m_className = this.m_className + this.m_localFileName;
        this.m_localFileName = fileName;
        this.m_localFile = new File(this.m_localFileName);
        if (!this.m_localFile.exists()) {
            throw new VWException("filenet.sim.animationdp.impl.VWSimLocalFileReader.FileNotFound", "File {0} not found!", this.m_localFileName);
        }
    }

    public VWSimLocalFileReader(String fileName) throws VWException {
        this.checkDATFile(fileName);
        this.posList.add(new Long(this.m_pos));
    }

    private ArrayList getList(String fileName) {
        ArrayList<Long> res = null;
        try {
            RandomAccessFile f = null;
            File ff = new File(fileName);
            if (!ff.exists()) {
                return res;
            }
            int nItems = (int)ff.length() / 8;
            res = new ArrayList<Long>(nItems);
            f = new RandomAccessFile(fileName, "r");
            for (int i = 0; i < nItems; ++i) {
                res.add(new Long(f.readLong()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public VWSimLocalFileReader(String datFileName, String inxFileName, String timeFileName) throws VWException {
        this.checkDATFile(datFileName);
        this.posList = this.getList(inxFileName);
        this.timeList = this.getList(timeFileName);
    }

    public AnimationManager getPrevious() throws VWException {
        if (this.m_nCurrentElement <= 0L) {
            return null;
        }
        --this.m_nCurrentElement;
        return this.get();
    }

    public AnimationManager get() throws VWException {
        String m_method = "getNext";
        if (this.m_nCurrentElement == 0L) {
            logger.fine(this.m_className, m_method, "Starting..");
        }
        try {
            this.m_pos = (Long)this.posList.get((int)this.m_nCurrentElement);
            if (this.m_file == null) {
                this.m_file = new RandomAccessFile(this.m_localFile, "r");
            }
            this.m_file.seek(this.m_pos);
            AnimationManager res = new AnimationManager();
            res.readFromStream(this.m_file);
            this.m_finished = res.finished();
            this.m_pos = this.m_file.getFilePointer();
            if (this.m_pos < this.m_localFile.length()) {
                ++this.m_nCurrentElement;
                if (this.m_nCurrentElement > (long)this.timeList.size()) {
                    this.timeList.add(new Long(res.getTimeStamp().getTime()));
                }
                if (this.m_nCurrentElement >= (long)this.posList.size()) {
                    this.posList.add(new Long(this.m_pos));
                }
            }
            return res;
        }
        catch (Throwable e) {
            logger.throwing(this.m_className, m_method, e);
            throw new VWException(e);
        }
    }

    public boolean hasNext() {
        return !this.m_finished;
    }

    public void releaseResources() {
        this.reset();
    }

    public void reset() {
        this.m_nCurrentElement = 0L;
        this.m_pos = 0L;
        if (this.m_file != null) {
            try {
                this.m_file.close();
                this.m_file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        this.releaseResources();
    }
}

